﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.MT;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorIconInfo
    {
        public static void CopyTo(this IconInfoBO iconInfoBO, DataContracts.IconInfo iconInfo)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                iconInfo.IconId = (iconInfoBO.ICON_ID.Value.HasValue) ? iconInfoBO.ICON_ID.Value.Value : -1;
                iconInfo.Group = iconInfoBO.GROUP.Value;
                iconInfo.Subgroup = iconInfoBO.SUBGROUP.Value;
                iconInfo.ImageBytes = iconInfoBO.IMAGE_BYTES.Value;
                iconInfo.ImageBytesInactive = iconInfoBO.IMAGE_BYTES_INACTIVE.Value;
                iconInfo.Active = (iconInfoBO.ACTIVE.Value.HasValue) ? iconInfoBO.ACTIVE.Value.Value : false;
                iconInfo.OrderIndex = (iconInfoBO.ORDER_INDEX.Value.HasValue) ? iconInfoBO.ORDER_INDEX.Value.Value : -1;
                iconInfo.IconDescription = iconInfoBO.ICON_DESCRIPTION.Value;
                iconInfo.IconName = iconInfoBO.ICON_NAME.Value;
                iconInfo.PatientOrRoomBed = iconInfoBO.PATIENT_OR_ROOMBED.Value;
                iconInfo.MouseOverText = iconInfoBO.MOUSE_OVER_TEXT.Value;
                iconInfo.AutoIconPattern = iconInfoBO.AUTO_ICON_PATTERN.Value;
                iconInfo.AutoIconActive = iconInfoBO.AUTO_ICON_ACTIVE.Value;
                iconInfo.IsIsolation = iconInfoBO.IS_ISOLATION.Value;
                iconInfo.FacilityId = TranslatorUtils.BuildIdentifier(null, iconInfoBO.FACILITY_UID);
                iconInfo.IconType = TranslatorUtils.BuildConcept(iconInfoBO.ICON_TYPE_CODE, iconInfoBO.ICON_TYPE_CODE_SYSTEM, iconInfoBO.ICON_TYPE_CODE_SYSTEM_NAME, iconInfoBO.ICON_TYPE_DISPLAY_NAME);
                iconInfo.Published = iconInfoBO.PUBLISHED.Value;
                iconInfo.ImageName = iconInfoBO.IMAGE_NAME.Value;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
